﻿using UnityEngine;
using System.Collections;

public class Share : MonoBehaviour
{

    public Room _Room;

    private const string FACEBOOK_APP_ID = "651916431584711";
    private const string FACEBOOK_URL = "http://www.facebook.com/dialog/feed";

    public void ShareToFacebook(string description)
    {
        ShareToFacebook(
			linkParameter: "http://anikki.itch.io/shift", 
            nameParameter: "Shift;:.", 
            captionParameter: "A relatively relaxed action game.", 
            descriptionParameter: "Shift is a casual action game. It features an indirect control mechanic where the player changes the shape of an enclosed space, where a ball continiously bounces off its walls, in order to collect points while avoiding traps.",
            pictureParameter: "http://www.anikki.com/shift/shift.png", 
            redirectParameter: "http://www.anikki.com/shift/"
        );
    }

    private void ShareToFacebook(string linkParameter, string nameParameter, string captionParameter, string descriptionParameter, string pictureParameter, string redirectParameter)
    {
        Application.OpenURL(FACEBOOK_URL + "?app_id=" + FACEBOOK_APP_ID +
            "&link=" + WWW.EscapeURL(linkParameter) +
            "&name=" + WWW.EscapeURL(nameParameter) +
            "&caption=" + WWW.EscapeURL(captionParameter) +
            "&description=" + WWW.EscapeURL(descriptionParameter) +
            "&picture=" + WWW.EscapeURL(pictureParameter) +
            "&redirect_uri=" + WWW.EscapeURL(redirectParameter));
    }


    private const string TWITTER_ADDRESS = "http://twitter.com/intent/tweet";
    private const string TWEET_LANGUAGE = "en";

    public void ShareToTwitter()
    {
        Application.OpenURL(TWITTER_ADDRESS +
			"?text=" + WWW.EscapeURL("I've scored " + _Room._Score.BestScore + " points in Shift;:. Play now: http://anikki.itch.io/shift #LDJAM") + 
            "&amp;lang=" + WWW.EscapeURL(TWEET_LANGUAGE));
    }
}
