﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class Mover : MonoBehaviour
{
    private Vector2 dragStart;
    private float strength;
    private Vector2 direction;
    private Vector2 currentPos;
    public Score _Score;
    public Text _IslandScore;
    public GameObject _SparksFX;
    public Room _Room;
    public bool _Blocked;
    public AudioClip ShatterSFX;
    public AudioClip SplashSFX;
    public AudioClip SparkSFX;
    private AudioSource _audioSource;


    // Use this for initialization
    void Start()
    {
        _audioSource = GetComponent<AudioSource>();
    }
	
    // Update is called once per frame
    void Update()
    {
        strength = 500f; // 500
        direction = Vector3.up;

        if (_Room._GameOver && Time.time < _Room._GameOverTS + _Room._GameOverDelay)
            return;

        if (_Room._GameOver)
        {
            transform.position = new Vector3(Room.WIDTH / 2, Room.HEIGHT / 2, 0);
        }
    }

    void OnDrawGizmos()
    {
        Gizmos.DrawLine(Vector3.zero, (Vector3)(direction * strength));
    }

    void OnCollisionEnter2D(Collision2D coll)
    {
        _Score.DeductIslandPoints(1);
        var spark = Instantiate(
                        _SparksFX, 
                        new Vector3(
                            coll.contacts[0].point.x, 
                            coll.contacts[0].point.y, 
                            0f), 
                        Quaternion.LookRotation(new Vector3(coll.contacts[0].normal.x, coll.contacts[0].normal.y, 0)));
        Destroy(spark, 2f);
    }

    public void Go()
    {
        transform.position = new Vector3(Room.WIDTH / 2, Room.HEIGHT / 2, 0);
        GetComponent<Rigidbody2D>().velocity = Vector2.zero;
        GetComponent<Rigidbody2D>().AddForce(strength * direction);
    }

    void OnTriggerEnter2D(Collider2D coll)
    {
        if (coll.tag == "NextRoom")
        {
            //Debug.Log("Blocked");
            _Blocked = true;
        }
        if (coll.tag == "Island")
        {
            coll.GetComponent<Island>().Shatter(this.GetComponent<Rigidbody2D>());
            _Score.AddPoints();
            StartCoroutine("MakeScreenshot");
        }
        if (coll.tag == "Title")
        {
            coll.GetComponent<Title>().Shatter(this.GetComponent<Rigidbody2D>());
        }

/*        var spark = Instantiate(
            Sparks, 
            transform.position, 
            Quaternion.LookRotation(rigidbody2D.velocity));
        Destroy(spark, 5f);*/

    }

    void OnTriggerExit2D(Collider2D coll)
    {
        if (coll.tag == "NextRoom")
        {
            _Blocked = false;
        }

    }

    IEnumerator MakeScreenshot()
    {
        yield return new WaitForSeconds(0.25f);
        yield return new WaitForEndOfFrame();
        Texture2D tex = new Texture2D(Screen.width, Screen.height);
        tex.ReadPixels(new Rect(0, 0, Screen.width, Screen.height), 0, 0);
        tex.Apply();
        _Room._ScoreScreenshot = tex;
    }
}
