﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;
using System.Collections.Generic;
using SimplexNoise;

public class Island : MonoBehaviour
{
    public int _Level = 0;
    public GameObject _NextIsland;
    public GameObject _ShatterFX;
    public GameObject _CrumbleFX;
    public GameObject _PointsFX;
    public Room _Room;
    public Color32 _NextIslandColor = new Color32(163, 59, 38, 128);
    private PolygonCollider2D polyCollider;
    private int seed = 51;
    Vector2[] currentIslandPoints;
    Vector2[] nextIslandPoints;

    // Use this for initialization
    void Start()
    {
        Random.seed = seed;
        polyCollider = GetComponent<PolygonCollider2D>();
        currentIslandPoints = NewIsland();
        nextIslandPoints = NewIsland();
        Next();
    }

    // Update is called once per frame
    void Update()
    {
    }

    public GameObject Next()
    {
        transform.position = new Vector3(_NextIsland.transform.position.x, _NextIsland.transform.position.y, 0);
        nextIslandPoints = NewIsland();
        polyCollider.SetPath(0, currentIslandPoints);
        GetComponent<MeshFilter>().mesh = Triangulator.PolygonMesh(currentIslandPoints);
        _NextIsland.GetComponent<MeshFilter>().mesh = Triangulator.PolygonMesh(nextIslandPoints);
        _NextIsland.GetComponent<PolygonCollider2D>().points = nextIslandPoints;
        _NextIsland.transform.position = new Vector3(
            Random.Range(Room.WIDTH / 6f, Room.WIDTH - Room.WIDTH / 6f),
            Random.Range(Room.HEIGHT / 4f, Room.HEIGHT - Room.HEIGHT / 8f),
            _NextIsland.transform.position.z
        );
        currentIslandPoints = nextIslandPoints;
        return _NextIsland;
    }

    void OnGUI()
    {

    }

    public void Shatter(Rigidbody2D impactor)
    {
        var shatterFX = Instantiate(
                            _ShatterFX,
                            new Vector3(
                                transform.position.x, 
                                transform.position.y, 
                                0), 
                            Quaternion.LookRotation(impactor.velocity)
                        );
        Destroy(shatterFX, 3f);

        var pointsFX = (GameObject)Instantiate(
                           _PointsFX,
                           new Vector3(
                               transform.position.x, 
                               transform.position.y, 
                               0), 
                           Quaternion.identity
                       );
        pointsFX.GetComponentInChildren<Text>().text = "+" + _Room._Score.IslandPoints;
        Destroy(pointsFX, 2f);

        gameObject.SetActive(false);
    }

    public void Crumble()
    {
        var fx = Instantiate(
                     _CrumbleFX,
                     new Vector3(
                         transform.position.x, 
                         transform.position.y, 
                         0), 
                     Quaternion.identity
                 );
        Destroy(fx, 3f);

        var pointsFX = (GameObject)Instantiate(
                           _PointsFX,
                           new Vector3(
                               transform.position.x, 
                               transform.position.y, 
                               0), 
                           Quaternion.identity
                       );
        pointsFX.GetComponentInChildren<Text>().text = "-" + _Room._Score.IslandPoints;
        Destroy(pointsFX, 2f);

        gameObject.SetActive(false);
    }


    /// <summary>
    /// Returns a list of points forming a randomized, approximately rectangular shape.
    /// Generates a sequence of points with x and y variation within certain bounds. this line gets folded to form a square.
    /// </summary>
    /// <returns>The island.</returns>
    private Vector2[] NewIsland()
    {
        float minRadius = Room.WIDTH / 18f;
        float maxRadius = Room.WIDTH / 12f;
        float angleMin = Mathf.PI * 0.25f;
        float angleMax = Mathf.PI * 0.5f;
        List<Vector2> points = new List<Vector2>();

        // outisde + entry
        float lastAngle = 0;
        // random shape
        for (int i = 0; i < Mathf.PI * 2 / angleMin; i++)
        {
            // how far off the median was the last step in x direction
            var radiusMax = maxRadius;
            var radiusMin = minRadius;
            var angleStepMin = lastAngle + angleMin;
            var angleStepMax = lastAngle + angleMax;

            var radius = Random.Range(radiusMin, radiusMax);
            var angle = Random.Range(angleStepMin, angleStepMax);
            var newPos = new Vector2(Mathf.Sin(angle), Mathf.Cos(angle)) * radius;
            if (lastAngle > Mathf.PI * 1.95f)
            {
                break;
            }

            points.Add(newPos);
            lastAngle = angle;
        }

        // close exit
        return points.ToArray();
    }


}
