﻿using UnityEngine;
using System.Collections;

public class GameControl : MonoBehaviour
{
	public Texture2D _Cursor;
	public Room _Room;
	public GameObject _Help;

	void Awake()
	{
		Cursor.visible = true;
		//Cursor.SetCursor(_Cursor, new Vector2(0, 0), CursorMode.Auto);
		_Help.SetActive(false);
	}
	
	void Update()
	{
		if ((Input.GetKey(KeyCode.LeftAlt) || 
			Input.GetKey(KeyCode.LeftCommand) || 
			Input.GetKey(KeyCode.LeftControl)) && 
			Input.GetKeyDown(KeyCode.Q)) {
			Application.Quit();
		}

		if (Input.GetKeyDown(KeyCode.H) || Input.GetKeyDown(KeyCode.Escape))
		{
			if (!_Help.activeInHierarchy) {
				_Help.SetActive(true);
				Time.timeScale = 0;
			} else {
				_Help.SetActive(false);
				Time.timeScale = 1f;
			}
		}

		if (_Room.IsGameOver) {
			Cursor.visible = true;
		} else {
			Cursor.visible = false;
		}
	}
}
