﻿using System;
using LibTessDotNet;
using UnityEngine;

public static class ExtensionMethods
{
    public static Vector3 ToVector3(this Vec3 value)
    {
        return new Vector3(value.X, value.Y, value.Z);
    }

    public static Vec3 ToVec3(this Vector3 value)
    {
        return new Vec3
        {
            X = value.x, 
            Y = value.y, 
            Z = value.z 
        };
    }

    public static Vec3 ToVec3(this Vector2 value)
    {
        return new Vec3
        {
            X = value.x, 
            Y = value.y, 
            Z = 0f 
        };
    }

    public static Vector3[] ToVector3(this Vec3[] values)
    {
        var v = new Vector3[values.Length];
        for (int i = 0; i < values.Length; i++)
        {
            v[i] = values[i].ToVector3();
        }
        return v;
    }
}