﻿using UnityEngine;
using System.Collections.Generic;
using System.Linq;
using LibTessDotNet;

public class Triangulator
{
    private static object VertexCombine(Vec3 position, object[] data, float[] weights)
    {
        return null;
    }

    public static Mesh PolygonMesh(Vector2[] points)
    {

        // Get origin of points
        Vector2 offset = new Vector2(points.Min(p => p.x) * -1, points.Min(p => p.y) * -1);

        // Get bounding box dimensions of points
        Vector2 dim = new Vector2(
                          points.Max(p => p.x) + offset.x,
                          points.Max(p => p.y) + offset.y
                      );

        // Tesselate to get triangles
        Tess tess = new Tess();
        ContourVertex[] contour = new ContourVertex[points.Length];
        for (int i = 0; i < contour.Length; i++)
        {
            contour[i].Position = points[i].ToVec3();
        }
        tess.AddContour(contour, ContourOrientation.Original);
        tess.Tessellate(WindingRule.Positive, ElementType.Polygons, 3, VertexCombine);

        // Create the Vector3 vertices
        Vector3[] vertices = new Vector3[tess.VertexCount];
        for (int i = 0; i < vertices.Length; i++)
        {
            vertices[i] = tess.Vertices[i].Position.ToVector3();
        }

        // Create the Vector2 uvs
        Vector2[] uvs = new Vector2[vertices.Length];
        for (int i = 0; i < uvs.Length; i++)
        {
            uvs[i] = new Vector2(
                (offset.x + vertices[i].x) / dim.x,
                (offset.y + vertices[i].y) / dim.y
            );
        }


        // Create the mesh
        Mesh msh = new Mesh();
        msh.vertices = vertices;
        msh.triangles = tess.Elements;
        msh.uv = uvs;
        msh.RecalculateNormals();
        msh.RecalculateBounds();
        return msh;
    }
}