﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class Tutorial : MonoBehaviour
{

    public Room Room;
    public Text TutorialText;
    public Text TutorialTitle;
    public Button FBButton;
    public Button TwitterButton;

    // Use this for initialization
    void Start()
    {
    }

    // Update is called once per frame
    void Update()
    {
        FBButton.gameObject.SetActive(false);
        TwitterButton.gameObject.SetActive(false);

        if (Room._GameOver)
        {
            TutorialTitle.text = "G A M E   O V E R";
            TutorialText.text = "[Space] to restart";
            FBButton.gameObject.SetActive(true);
            TwitterButton.gameObject.SetActive(true);

            return;
        }

        if (!Room._Started)
        {
            TutorialTitle.text = "";
            TutorialText.text = "[Space] to play\n[H] for help";

            return;
        }

        if (Room._Started && Room._Level - Room._StartLevel < 3)
        {
            TutorialTitle.text = "";
            TutorialText.text = "[Space] to change shape";

            return;
        }

        TutorialText.text = "";
    }
}
