﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;
using System.Collections.Generic;
using SimplexNoise;

public class Title : MonoBehaviour
{
    public int _Level = 0;
    public GameObject _ShatterFX;
    public Room _Room;
    private PolygonCollider2D polyCollider;
    Vector2[] titleIslandPoints;

    // Use this for initialization
    void Start()
    {
        Random.seed = gameObject.GetInstanceID();
        polyCollider = GetComponent<PolygonCollider2D>();
        titleIslandPoints = NewIsland();
        Next();
    }

    // Update is called once per frame
    void Update()
    {
    }

    public void Next()
    {
        //transform.position = new Vector3(Room.WIDTH / 2, Room.HEIGHT - Room.HEIGHT / 4, transform.position.z);
        polyCollider.SetPath(0, titleIslandPoints);
        GetComponent<MeshFilter>().mesh = Triangulator.PolygonMesh(titleIslandPoints);
        GetComponent<PolygonCollider2D>().points = titleIslandPoints;
    }

    public void Shatter(Rigidbody2D impactor)
    {
		GameObject shatterFX = (GameObject)Instantiate(
                            _ShatterFX,
                            new Vector3(
                                transform.position.x, 
                                transform.position.y, 
                                0), 
                            Quaternion.identity
                        );
		shatterFX.GetComponent<ParticleSystem>().startColor = _Room._BackgroundColor;
        Destroy(shatterFX, 1.5f);
        Invoke("Deactivate", 1.5f);
    }


    void Deactivate()
    {
        gameObject.transform.parent.gameObject.SetActive(false);
    }

    /// <summary>
    /// Returns a list of points forming a randomized, approximately rectangular shape.
    /// Generates a sequence of points with x and y variation within certain bounds. this line gets folded to form a square.
    /// </summary>
    /// <returns>The island.</returns>
    private Vector2[] NewIsland()
    {
        float minRadius = Room.WIDTH / 16f;
        float maxRadius = Room.WIDTH / 8f;
        float angleMin = Mathf.PI * 0.25f;
        float angleMax = Mathf.PI * 0.5f;
        List<Vector2> points = new List<Vector2>();

        // outisde + entry
        float lastAngle = 0;
        // random shape
        for (int i = 0; i < Mathf.PI * 2 / angleMin; i++)
        {
            // how far off the median was the last step in x direction
            var radiusMax = maxRadius;
            var radiusMin = minRadius;
            var angleStepMin = lastAngle + angleMin;
            var angleStepMax = lastAngle + angleMax;

            var radius = Random.Range(radiusMin, radiusMax);
            var angle = Random.Range(angleStepMin, angleStepMax);
            var newPos = new Vector2(Mathf.Sin(angle) * 3f, Mathf.Cos(angle)) * radius;
            if (lastAngle > Mathf.PI * 1.95f)
            {
                break;
            }

            points.Add(newPos);
            lastAngle = angle;
        }

        // close exit
        return points.ToArray();
    }


}
