﻿using UnityEngine;
using System.Collections;
using UnityEngine.UI;

[RequireComponent(typeof(Text))]
public class TextBump : MonoBehaviour
{
	float spawnTS;
	float startSize;
	public float _BumpFactor;
	float targetSize;
	Text tx;
	public float duration;
	string lastFrame;


	// Use this for initialization
	void Awake()
	{
		tx = GetComponent<Text>();
		targetSize = transform.localScale.x;
		startSize = targetSize;
		spawnTS = Time.time;
		lastFrame = tx.text;
	}

	// Update is called once per frame
	void Update()
	{
		if (tx.text != lastFrame && Time.frameCount > 10) {
			startSize = transform.localScale.x * _BumpFactor;
			spawnTS = Time.time;
		}
		transform.localScale = Vector3.one * Mathf.Lerp(startSize, targetSize, (Time.time - spawnTS) / duration);
		lastFrame = tx.text;
	}

}