﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class Score : MonoBehaviour
{

    int _score;
    int _best;
    public Room Room;
    public Text ScoreText;
    public Text BestText;
    public Text RoomText;
    public Text IslandText;
    public int MaxIslandPoints = 25;
    private int currentIslandPoints = 25;

    public int IslandPoints
    {
        get
        {
            return currentIslandPoints;
        }
    }

    // Use this for initialization
    void Start()
    {
        transform.position = new Vector3(Room.WIDTH / 2f, Room.HEIGHT / 2f, transform.position.z);
    }
	
    // Update is called once per frame
    void Update()
    {
        RoomText.text = "" + Room._Level;
        ScoreText.text = "" + _score;
        BestText.text = "" + _best;
        if (!Room._GameOver)
            IslandText.text = "" + currentIslandPoints;
        else
            IslandText.text = "";
    }

    public void AddPoints()
    {
        _score += currentIslandPoints;
        if (_score > _best)
            _best = _score;
    }

    public void DeductPoints()
    {
        _score += currentIslandPoints * -1;
        if (_score < 0)
            _score = 0;

        if (_score > _best)
            _best = _score;
    }

    public void DeductIslandPoints(int p)
    {
        currentIslandPoints = Mathf.Clamp(currentIslandPoints - p, 0, MaxIslandPoints);
    }

    public void ResetScore()
    {
        _score = 0;
    }

    public int BestScore
    {
        get {
            return _score;

        }
    }

    public void ResetIslandScore()
    {
        currentIslandPoints = MaxIslandPoints;
    }

    void OnGUI()
    {

    }
}
