﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;
using System.Collections.Generic;
using SimplexNoise;

[RequireComponent(typeof(Text))]
public class FadeText : MonoBehaviour
{
    float spawnTS;
    Text tx;
    Color32 startColor;
    Color32 targetColor;
	float startSize;
	float targetSize;
    public float duration;

    // Use this for initialization
    void Start()
    {
        tx = GetComponent<Text>();
        startColor = (Color32)tx.color;
        targetColor = new Color32(startColor.r, startColor.g, startColor.b, 0);
		startSize = transform.localScale.x;
		targetSize = 1.5f;
        spawnTS = Time.time;

    }

    // Update is called once per frame
    void Update()
    {
        tx.color = Color32.Lerp(startColor, targetColor, (Time.time - spawnTS) / duration);
		transform.localScale = Vector3.one * Mathf.Lerp(startSize, targetSize, (Time.time - spawnTS) / duration);
    }

}
